/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.action;

import jp.mosp.common.action.MosPWorkflowAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.workflow.dto.AmUnitDto;
import jp.mosp.workflow.vo.ApprovalUnitCardVo;

public class ApprovalUnitCardAction extends MosPWorkflowAction {

	// R}h
	private static final String CMD_UNIT_CARD_SHOW   = "S2815";	// \(ǉ)
	private static final String CMD_UNIT_CARD_SELECT = "S2816";	// \(I)
	private static final String CMD_UNIT_CARD_INSERT = "S2817";	// o^
	private static final String CMD_UNIT_CARD_UPDATE = "S2818";	// XV

	/**
	 * RXgN^
	 */
	public ApprovalUnitCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		// VO̎擾yѐݒ
		ApprovalUnitCardVo vo = new ApprovalUnitCardVo();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.setParams(request);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DAO̐錾
		prepareAmUnitDao();
		// DTO̎擾
		AmUnitDto dto;
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof AmUnitDto ? (AmUnitDto)obj : null;
		// v_ẼZbg
		setPulldownList(vo);
		// R}h̏
		if (cmd.equals(CMD_UNIT_CARD_SHOW)) {
			vo.setDefaultValues();
			vo.setPltStartYear(String.valueOf(MospUtility.getYear(getStartDate(util.getSystemDate()))));
			vo.setPltStartMonth(String.valueOf(MospUtility.getMonth(getStartDate(util.getSystemDate()))));
			/*						
			 *  	2008/11/04	m.yoshida	C
			 */
			vo.setPltStartDay(String.valueOf(MospUtility.getDay(getStartDate(util.getSystemDate()))));
			// [hݒ
			setMode(vo);
		} else if (cmd.equals(CMD_UNIT_CARD_SELECT)) {
			// \(L[ŏ)
			// f[^̎擾
			dto = unitDao.findForKey(key1, key2);
			chkExist(dto);
			// VOɏZbg
			vo.setFields(dto);
			vo.setMode(ApprovalUnitCardVo.MODE_UPDATE);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_UNIT_CARD_INSERT)) {
			// VKo^
			dto = insert(vo);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_UNIT_CARD_UPDATE)) {
			// XV
			dto = update(vo, dto);
			// ZbVDTOZbg
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * v_E̐ݒ
	 * @param vo
	 * @throws Exception
	 */
	private void setPulldownList(ApprovalUnitCardVo vo) throws Exception {
		// DBRlNV̎擾
		if (conn == null) {
			getConnection();
		}
		// MANAGERLЈR[hꗗ
		vo.aryPltManager	= getBasisArrayForApproval();
		// N
		vo.aryPltYear		= util.getYearArray(MospUtility.getYear(util.getSystemDate()), 10, 5);
		// 
		vo.aryPltMonth		= util.getMonthArray();
		/*
		 * 		2008/11/06	m.yoshida	C
		 */		
		// 
		vo.aryPltDay		= util.getDayArray();
	}

	/**
	 * f[^}
	 * @param vo ΏVO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	private AmUnitDto insert(ApprovalUnitCardVo vo) throws Exception {
		// p[^̑ÓmF
		vo.validate();
		// DAȌ
		prepareAmUnitDao();
		// ݃`FbN
		chkDuplicate(unitDao.findForKey(vo.getTxtUnitCode(),
				util.convStringDateFormattedByHyphen(
						/*						
						 *  	2008/11/04	m.yoshida	C
						 */
						vo.getPltStartYear(), vo.getPltStartMonth(), vo.getPltStartDay())
		), vo);
		// DTȌ
		AmUnitDto dto = new AmUnitDto();
		vo.setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
		vo.setDtoFields(dto);
		// f[^̑}
		unitDao.insert(dto);
		// DTO̍Ď擾
		dto = unitDao.findForKey(dto.getUnitCode(), dto.getStartDate());
		// R~bg
		commit();
		// [hݒ
		vo.setMode(ApprovalUnitCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_INSERT, ""));
		return dto;
	}

	/**
	 * f[^XV
	 * @param vo ΏVO
	 * @param dto ΏDTO
	 * @return f[^}ΏDTO
	 * @throws Exception
	 */
	private AmUnitDto update(ApprovalUnitCardVo vo, AmUnitDto dto) throws Exception {
		// R[h擾
		vo.setTxtUnitCode(dto.getUnitCode());
		// N擾
		vo.setPltStartYear(util.removeZero(util.divideByHyphen(dto.getStartDate(), 2)[0]));
		vo.setPltStartMonth(util.removeZero(util.divideByHyphen(dto.getStartDate(), 2)[1]));
		/*						
		 *  	2008/11/04	m.yoshida	C
		 */
		vo.setPltStartDay(util.removeZero(util.divideByHyphen(dto.getStartDate(), 2)[2]));
		// p[^̑ÓmF
		vo.validate();
		// DAȌ
		prepareAmUnitDao();
		// rmF
		chkExclusive(dto, unitDao.findForUpdate(vo.getTxtUnitCode(),
				util.convStringDateFormattedByHyphen(
						/*						
						 *  	2008/11/04	m.yoshida	C
						 */
						vo.getPltStartYear(), vo.getPltStartMonth(), vo.getPltStartDay())
		), vo);
		// DTȌ
		vo.setDtoFields(dto);
		// f[^̍XV
		unitDao.update(dto);
		// DTO̍Ď擾
		AmUnitDto retDto = unitDao.findForKey(dto.getUnitCode(), dto.getStartDate());
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(ApprovalUnitCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		return retDto;
	}

	/**
	 * [hݒ
	 * @param vo ΏVO
	 * @throws Exception
	 */
	private void setMode(ApprovalUnitCardVo vo) throws Exception {
		// [hݒ
		if (vo.aryPltManager.length == 0) {
			vo.setMode(ApprovalUnitCardVo.MODE_IMPOSSIBLE);
		} else {
			vo.setMode(ApprovalUnitCardVo.MODE_INSERT);
		}
	}

}
